LEDHoleRadius = 3.5;
tubeLength = 30;
wallThickness = 1.8;
boltRadius = 2;

tubeOffset = LEDHoleRadius+wallThickness*1.5;

$fn = 200;

translate([tubeOffset, 0, 0]){
    tube(tubeLength, LEDHoleRadius);
}
translate([-(tubeOffset), 0, 0]){
    tube(tubeLength, 2.6);
}
translate([0, -tubeOffset*1.74, -(tubeLength - tubeLength/10)/2]){
    tube(tubeLength/10, LEDHoleRadius);
}

translate([0,wallThickness*3, -0.5*tubeLength + boltRadius*3]){
    mount();
}

module tube(functionLength, functionHole){
    difference(){
        cylinder(functionLength, LEDHoleRadius+wallThickness*2, LEDHoleRadius+wallThickness*2, center = true);
        translate([0,0,wallThickness]){    
            cylinder(functionLength, LEDHoleRadius+wallThickness, LEDHoleRadius+wallThickness, center = true);
        }
        cylinder(functionLength*2, functionHole, functionHole, center = true);
    }
}

module mount(){
    difference(){
        translate(){
            cube([wallThickness, boltRadius *6, boltRadius *6], center = true);
            rotate([90,0,90]){
                translate([boltRadius*3, 0, 0]){
                    cylinder(wallThickness, boltRadius*3, boltRadius*3, center = true);
                }
            }
        }
        rotate([90,0,90]){
                translate([boltRadius*3, 0, 0]){
                    cylinder(wallThickness*2, boltRadius, boltRadius, center = true);
                }
            }
    }
}